﻿using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Collections;
using System.Drawing;
using System.Linq;
using System.Workflow.ComponentModel.Compiler;
using System.Workflow.ComponentModel.Serialization;
using System.Workflow.ComponentModel;
using System.Workflow.ComponentModel.Design;
using System.Workflow.Runtime;
using System.Workflow.Activities;
using System.Workflow.Activities.Rules;



/*  WhileActivity conditional activity class
    SequenceActivity class

    This example uses a SequenceActivity as the sole child of a WhileActivity, since the workflow designer permits 
    just a single child activity to a WhileActivity. The SequenceActivity is a simple CompositeActivity derived class
    which may have any number of child activities. 

    The SequenceActivity executes its child activities in sequence, one after the other.
 
 */
namespace Lessons.Workflows
{
	public sealed partial class Workflow1: SequentialWorkflowActivity
	{
		public Workflow1()
		{
			InitializeComponent();
		}


        void actWhile_Condition(object sender, ConditionalEventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine("=============================================");
            Console.WriteLine(a.Name + ": Continue execution? (Y/N)");
            string S = Console.ReadLine();
            e.Result = S.ToUpper() == "Y";
        }

        int N;

        private void actNumberInput_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": Enter a number between 0 and 9...");
            N = int.Parse(Console.ReadLine()); 
        }

        void actNumberLess_Condition(object sender, ConditionalEventArgs e)
        {
            e.Result = N < 5;
        }

        void actNumberGreater_Condition(object sender, ConditionalEventArgs e)
        {
            e.Result = N > 5;
        }

        private void actProcessLess_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": N < 5");
        }

        private void actProcessGreater_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": N > 5");
        }

        private void actProcessLess_ExecuteCode2(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": a second CodeActivity inside a branch");
        }

        private void actProcessEqual_ExecuteCode(object sender, EventArgs e)
        {
            Activity a = sender as Activity;
            Console.WriteLine(a.Name + ": N == 5");
        }

 
	}

}
